

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Auto timers, usefull when debugging  ;
; turn off or set high to save cpu     ;
; when debug is done                   ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
SetTimer,AutoReloadScript,1000 

; ***** initialization *****
#WinActivateForce
SetBatchLines, -1   ; maximize script speed!
SetWinDelay, -1
OnExit, CleanUp     ; clean up in case of error (otherwise some windows will get lost)

numDesktops := 4    ; maximum number of desktops
curDesktop := 1     ; index number of current desktop

;===== HOTKEYS =====
;numbers
^1::
if GetKeyState("Space")	;(space_state = "D") deleteme
	SwitchToDesktop(1)
return

;arrows
^Left::
if GetKeyState("Space")
{
	newDesktop := DetermineNewDesktop("l")
	msgbox %newDesktop%
	;SwitchToDesktop(newDesktop)
}
return

^Right::
if GetKeyState("Space")
{
	newDesktop := DetermineNewDesktop("r")
	msgbox %newDesktop%
	;SwitchToDesktop(newDesktop)
}
return

^Up::
if GetKeyState("Space")
{
	newDesktop := DetermineNewDesktop("u")
	msgbox %newDesktop%
	;SwitchToDesktop(newDesktop)
}
return

^Down::
if GetKeyState("Space")
{
	newDesktop := DetermineNewDesktop("d")
	msgbox %newDesktop%
	;SwitchToDesktop(newDesktop)
}
return

;debugging
!0::ExitApp

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; AutoScriptReload/Suspend ;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
AutoReloadScript:
   FileGetAttrib,attribs,%A_ScriptFullPath%
   IfInString,attribs,A
   {
      FileSetAttrib,-A,%A_ScriptFullPath%
	  msgbox Reloading.
	  Reload
   }
return 


;===== FUNCTIONS =====
SwitchToDesktop(newDesktop)
{
   global

   if (curDesktop <> newDesktop)
   {
      GetCurrentWindows(curDesktop)
      ShowHideWindows(curDesktop, false)	;hide current windows
      ShowHideWindows(newDesktop, true)		;show new windows
      activate_window := % active_id%newDesktop%	;active the new active window with the stored ID
      WinActivate, ahk_id %activate_window%
      ;TrayTip, DesktopSwitch, Switching to desktop %newDesktop%
      ToolTip, Switching to desktop %newDesktop%

	sleep 1000
	tooltip
      curDesktop := newDesktop
   }
   return
   ;JON SMITHERS______instead I would put:
   ;GetCurrentPositions(curDesktop)  ...store them into an array
   ;Exit current windows 
	  ;(move a list of windows symotaneously a fixed distance. The same function can be moving them out, or moving them in. It just has to know which direction to move them)
   ;Position the entering windows using the array
   ;Enter windows of newDesktop
		;activate top window
		;question...how will full screen work? I'm afraid it won't from testing gmail
}

;(determines which is the new Desktop based on which arrow key is pressed and which is the current desktop
DetermineNewDesktop(arrow)
{
	global curDesktop
	
	if (arrow = "r")
		newDesktop := curDesktop + 1
	else if (arrow = "l")
		newDesktop := curDesktop - 1
	else if (arrow = "u")
		newDesktop := curDesktop - 2
	else if (arrow = "d")
		newDesktop := curDesktop + 2
	if (newDesktop < 1)
		newDesktop := newDesktop + 4
	else if (newDesktop > 4)
		newDesktop := newDesktop - 4
	return newDesktop
}

;(sends the given window from the current desktop to the given desktop)
SendToDesktop(windowID, newDesktop)
{
   global
   if (curDesktop <> newDesktop)
   {
   RemoveWindowID(curDesktop, windowID)

   ; add window to destination desktop
   windows%newDesktop% += 1
   i := windows%newDesktop%

   windows%newDesktop%%i% := windowID
   
   WinHide, ahk_id %windowID%
   ;TrayTip, DesktopSwitch, Window send to desktop %newDesktop%
   Tooltip, Window Send to desktop %newDesktop%

   Send, {ALT DOWN}{TAB}{ALT UP}   ; activate the right window
   }
}

;(sends the currently active window to the given desktop)
SendActiveToDesktop(newDesktop)
{
   WinGet, id, ID, A
   SendToDesktop(id, newDesktop)
}

;(removes the given window id from the desktop <desktopIdx>)
RemoveWindowID(desktopIdx, ID)
{
   global
   Loop, % windows%desktopIdx%
   {
      if (windows%desktopIdx%%A_Index% = ID)
      {
         windows%desktopIdx%%A_Index%=      ;Emiel: just empty the array element, array will be emptied by next switch anyway
         Break
      }
   }
}

;(this builds a list of all currently visible windows in stores it in desktop <index>)
GetCurrentWindows(index)
{
   global
   WinGet, active_id%index%, ID, A                      ; get the current active window
   emptyString =
   StringSplit, windows%index%, emptyString             ; Emiel: delete the entire windows_index_ array 
   WinGet, windows%index%, List,,, Program Manager      ; get list of all visible windows

   ; remove windows which we want to see on all virtual desktops
   Loop, % windows%index%
   {
      id := % windows%index%%A_Index%
      WinGetClass, windowClass, ahk_id %id%
      if windowClass = Shell_TrayWnd     ; remove task bar window id
           windows%index%%A_Index%=      ; Emiel: just empty the array element, array will be emptied by next switch anyway
      if windowClass = #32770            ; Emiel: we also want multimontaskbar on all virtual desktops
           windows%index%%A_Index%=      ; Emiel: just empty the array element, array will be emptied by next switch anyway
      if windowClass = cygwin/x X rl-xosview-XOsview-0   ; Emiel: xosviews e.d.
           windows%index%%A_Index%=      
      if windowClass = cygwin/x X rl-xosview-XOsview-1   ; Emiel: xosviews e.d.
           windows%index%%A_Index%=      
      if windowClass = MozillaUIWindowClass              ; Mozilla thunderbird
      {
        WinGet, ExStyle, ExStyle, ahk_id %id%
          if (ExStyle & 0x8)  ; 0x8 is WS_EX_TOPMOST.    ; Alleen de mailboxalertmelding!
           windows%index%%A_Index%=      
      }
   }
}

; if show=true then shows windows of desktop %index%, otherwise hides them
ShowHideWindows(index, show)
{
   global

   Loop, % windows%index%
   {
      id := % windows%index%%A_Index%
      if show
         WinShow, ahk_id %id%
      else
         WinHide, ahk_id %id%
   }
}

; show all windows from all desktops on exit
CleanUp:
Loop, %numDesktops%
   ShowHideWindows(A_Index, true)
ExitApp 
























; Version history:
;
; v1.14, 25 jun 2009 Emiel Witteman
; Fixed bug window disappearing when sending it to the current desktop

; v1.13, 08 sept 2008 Emiel Witteman
; Fixed bugs in array housekeeping, explained the faulty hide/show of some windows
;
; v1.12, 08 sept 2008 Emiel Witteman
; Code cleanup, removed some redundant code from previous versions.
; Added support for MultiMonTaskbar (a taskbar on a second physical screen)
; Added storing of active window per virtual desktop
; Added Traytips to inform the user what happened
;
; v1.11, 22. Nov. 2005
; Fixed bug: windows are now corrrectly activated after switching/sending
;
; v1.1, 05. Nov. 2005
; Added feature: pressing Ctrl/Alt-<index> sends the active window to the desktop <index>.
;
; v1.0, 04. Nov. 2005
; It works!
; Switching can be done using Alt-<desktop index>, e.g. Alt-1. Pressing
; Alt-0 will exit the script and show all windows from all virtual desktops
; at once.
